#ifndef SNDINTRF_H
#define SNDINTRF_H


struct MachineSound
{
	int sound_type;
	void *sound_interface;
};


enum
{
	SOUND_DUMMY,
#if (HAS_YM2612)
	SOUND_YM2612,
#endif
#if (HAS_RF5C68)
	SOUND_RF5C68,
#endif
    SOUND_COUNT
};


/* structure for SOUND_CUSTOM sound drivers */
struct CustomSound_interface
{
	int (*sh_start)(const struct MachineSound *msound);
	void (*sh_stop)(void);
	void (*sh_update)(void);
};


int sound_start(void);
void sound_stop(void);
void sound_update(void);
void sound_reset(void);

/* returns name of the sound system */
const char *sound_name(const struct MachineSound *msound);
/* returns number of chips, or 0 if the sound type doesn't support multiple instances */
int sound_num(const struct MachineSound *msound);
/* returns clock rate, or 0 if the sound type doesn't support a clock frequency */
int sound_clock(const struct MachineSound *msound);

int sound_scalebufferpos(int value);


#endif
